// Code generated by go-swagger; DO NOT EDIT.

package project_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewProjectServiceGetProjectsCountParams creates a new ProjectServiceGetProjectsCountParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewProjectServiceGetProjectsCountParams() *ProjectServiceGetProjectsCountParams {
	return &ProjectServiceGetProjectsCountParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewProjectServiceGetProjectsCountParamsWithTimeout creates a new ProjectServiceGetProjectsCountParams object
// with the ability to set a timeout on a request.
func NewProjectServiceGetProjectsCountParamsWithTimeout(timeout time.Duration) *ProjectServiceGetProjectsCountParams {
	return &ProjectServiceGetProjectsCountParams{
		timeout: timeout,
	}
}

// NewProjectServiceGetProjectsCountParamsWithContext creates a new ProjectServiceGetProjectsCountParams object
// with the ability to set a context for a request.
func NewProjectServiceGetProjectsCountParamsWithContext(ctx context.Context) *ProjectServiceGetProjectsCountParams {
	return &ProjectServiceGetProjectsCountParams{
		Context: ctx,
	}
}

// NewProjectServiceGetProjectsCountParamsWithHTTPClient creates a new ProjectServiceGetProjectsCountParams object
// with the ability to set a custom HTTPClient for a request.
func NewProjectServiceGetProjectsCountParamsWithHTTPClient(client *http.Client) *ProjectServiceGetProjectsCountParams {
	return &ProjectServiceGetProjectsCountParams{
		HTTPClient: client,
	}
}

/*
ProjectServiceGetProjectsCountParams contains all the parameters to send to the API endpoint

	for the project service get projects count operation.

	Typically these are written to a http.Request.
*/
type ProjectServiceGetProjectsCountParams struct {

	/* ScopeID.

	   id is the id of the object being referenced.
	*/
	ScopeID *string

	/* ScopeType.

	   ResourceType is the type of object being referenced.

	   Default: "UNKNOWN"
	*/
	ScopeType *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the project service get projects count params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ProjectServiceGetProjectsCountParams) WithDefaults() *ProjectServiceGetProjectsCountParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the project service get projects count params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ProjectServiceGetProjectsCountParams) SetDefaults() {
	var (
		scopeTypeDefault = string("UNKNOWN")
	)

	val := ProjectServiceGetProjectsCountParams{
		ScopeType: &scopeTypeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the project service get projects count params
func (o *ProjectServiceGetProjectsCountParams) WithTimeout(timeout time.Duration) *ProjectServiceGetProjectsCountParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the project service get projects count params
func (o *ProjectServiceGetProjectsCountParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the project service get projects count params
func (o *ProjectServiceGetProjectsCountParams) WithContext(ctx context.Context) *ProjectServiceGetProjectsCountParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the project service get projects count params
func (o *ProjectServiceGetProjectsCountParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the project service get projects count params
func (o *ProjectServiceGetProjectsCountParams) WithHTTPClient(client *http.Client) *ProjectServiceGetProjectsCountParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the project service get projects count params
func (o *ProjectServiceGetProjectsCountParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithScopeID adds the scopeID to the project service get projects count params
func (o *ProjectServiceGetProjectsCountParams) WithScopeID(scopeID *string) *ProjectServiceGetProjectsCountParams {
	o.SetScopeID(scopeID)
	return o
}

// SetScopeID adds the scopeId to the project service get projects count params
func (o *ProjectServiceGetProjectsCountParams) SetScopeID(scopeID *string) {
	o.ScopeID = scopeID
}

// WithScopeType adds the scopeType to the project service get projects count params
func (o *ProjectServiceGetProjectsCountParams) WithScopeType(scopeType *string) *ProjectServiceGetProjectsCountParams {
	o.SetScopeType(scopeType)
	return o
}

// SetScopeType adds the scopeType to the project service get projects count params
func (o *ProjectServiceGetProjectsCountParams) SetScopeType(scopeType *string) {
	o.ScopeType = scopeType
}

// WriteToRequest writes these params to a swagger request
func (o *ProjectServiceGetProjectsCountParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ScopeID != nil {

		// query param scope.id
		var qrScopeID string

		if o.ScopeID != nil {
			qrScopeID = *o.ScopeID
		}
		qScopeID := qrScopeID
		if qScopeID != "" {

			if err := r.SetQueryParam("scope.id", qScopeID); err != nil {
				return err
			}
		}
	}

	if o.ScopeType != nil {

		// query param scope.type
		var qrScopeType string

		if o.ScopeType != nil {
			qrScopeType = *o.ScopeType
		}
		qScopeType := qrScopeType
		if qScopeType != "" {

			if err := r.SetQueryParam("scope.type", qScopeType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
