/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.layout;

import org.freeplane.api.ChildNodesLayout;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IExtensionAttributeWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.features.layout.LayoutModel;
import org.freeplane.features.map.NodeModel;

class LayoutBuilder
implements IExtensionAttributeWriter {
    LayoutBuilder() {
    }

    private void registerAttributeHandlers(ReadManager reader) {
        IAttributeHandler childNodesLayoutHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LayoutModel.createLayoutModel(node).setChildNodesLayout(ChildNodesLayout.valueOf((String)value));
            }
        };
        reader.addAttributeHandler("node", "CHILD_NODES_LAYOUT", childNodesLayoutHandler);
        reader.addAttributeHandler("stylenode", "CHILD_NODES_LAYOUT", childNodesLayoutHandler);
        IAttributeHandler verticalAlignmentHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LayoutModel.createLayoutModel(node).setChildNodesLayout(LayoutBuilder.this.layoutForAlignment(value));
            }
        };
        reader.addAttributeHandler("node", "CHILD_NODES_ALIGNMENT", verticalAlignmentHandler);
        reader.addAttributeHandler("stylenode", "CHILD_NODES_ALIGNMENT", verticalAlignmentHandler);
    }

    protected ChildNodesLayout layoutForAlignment(String alignment) {
        if ("AS_PARENT".equals(alignment) || "AUTO".equals(alignment)) {
            return ChildNodesLayout.AUTO;
        }
        if ("BY_FIRST_NODE".equals(alignment)) {
            return ChildNodesLayout.AUTO_FIRST;
        }
        if ("BY_CENTER".equals(alignment)) {
            return ChildNodesLayout.AUTO_CENTERED;
        }
        if ("BY_LAST_NODE".equals(alignment)) {
            return ChildNodesLayout.AUTO_LAST;
        }
        return ChildNodesLayout.NOT_SET;
    }

    void registerBy(ReadManager readManager, WriteManager writeManager) {
        this.registerAttributeHandlers(readManager);
        writeManager.addExtensionAttributeWriter(LayoutModel.class, this);
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, IExtension extension) {
        LayoutModel layoutModel = (LayoutModel)extension;
        ChildNodesLayout childrenNodesLayout = layoutModel.getChildNodesLayout();
        if (childrenNodesLayout != ChildNodesLayout.NOT_SET) {
            writer.addAttribute("CHILD_NODES_LAYOUT", childrenNodesLayout.name());
        }
    }
}

