/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jetbrains.kotlin.com.google.inject.ProvisionException;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanProperty;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanScheduler;

final class BeanPropertyField<T>
implements PrivilegedAction<Void>,
BeanProperty<T> {
    private final Field field;

    BeanPropertyField(Field field) {
        this.field = field;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.field.getAnnotation(annotationType);
    }

    @Override
    public TypeLiteral<T> getType() {
        return TypeLiteral.get(this.field.getGenericType());
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public <B> void set(B bean, T value) {
        if (!this.field.isAccessible()) {
            AccessController.doPrivileged(this);
        }
        BeanScheduler.detectCycle(value);
        try {
            this.field.set(bean, value);
        }
        catch (Exception e) {
            throw new ProvisionException("Error injecting: " + this.field, e);
        }
        catch (LinkageError e) {
            throw new ProvisionException("Error injecting: " + this.field, e);
        }
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof BeanPropertyField) {
            return this.field.equals(((BeanPropertyField)rhs).field);
        }
        return false;
    }

    public String toString() {
        return this.field.toString();
    }

    @Override
    public Void run() {
        this.field.setAccessible(true);
        return null;
    }
}

