/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.output;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.openapitools.openapidiff.core.exception.RendererException;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;
import org.openapitools.openapidiff.core.output.Render;

public class JsonRender
implements Render {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonRender() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.findAndRegisterModules();
    }

    @Override
    public void render(ChangedOpenApi diff, OutputStreamWriter outputStreamWriter) {
        try {
            this.objectMapper.writeValue(outputStreamWriter, (Object)diff);
            outputStreamWriter.close();
        }
        catch (JsonProcessingException e) {
            throw new RendererException("Could not serialize diff as JSON", e);
        }
        catch (IOException e) {
            throw new RendererException(e);
        }
    }
}

