/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.knn;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.knn.KnnMethod;
import org.opensearch.client.opensearch.knn.TrainModelResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class TrainModelRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, TrainModelRequest> {
    @Nullable
    private final String compressionLevel;
    @Nullable
    private final String description;
    private final int dimension;
    @Nullable
    private final Integer maxTrainingVectorCount;
    @Nullable
    private final KnnMethod method;
    @Nullable
    private final String mode;
    @Nullable
    private final String modelId;
    @Nullable
    private final String preference;
    @Nullable
    private final Integer searchSize;
    @Nullable
    private final String spaceType;
    @Nonnull
    private final String trainingField;
    @Nonnull
    private final String trainingIndex;
    public static final JsonpDeserializer<TrainModelRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainModelRequest::setupTrainModelRequestDeserializer);
    public static final Endpoint<TrainModelRequest, TrainModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TrainModelRequest, TrainModelResponse>(request -> "POST", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (request.modelId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_plugins/_knn/models/_train";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_knn/models/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/_train");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, TrainModelResponse._DESERIALIZER);

    private TrainModelRequest(Builder builder) {
        super(builder);
        this.compressionLevel = builder.compressionLevel;
        this.description = builder.description;
        this.dimension = ApiTypeHelper.requireNonNull(builder.dimension, this, "dimension");
        this.maxTrainingVectorCount = builder.maxTrainingVectorCount;
        this.method = builder.method;
        this.mode = builder.mode;
        this.modelId = builder.modelId;
        this.preference = builder.preference;
        this.searchSize = builder.searchSize;
        this.spaceType = builder.spaceType;
        this.trainingField = ApiTypeHelper.requireNonNull(builder.trainingField, this, "trainingField");
        this.trainingIndex = ApiTypeHelper.requireNonNull(builder.trainingIndex, this, "trainingIndex");
    }

    public static TrainModelRequest of(Function<Builder, ObjectBuilder<TrainModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String compressionLevel() {
        return this.compressionLevel;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final int dimension() {
        return this.dimension;
    }

    @Nullable
    public final Integer maxTrainingVectorCount() {
        return this.maxTrainingVectorCount;
    }

    @Nullable
    public final KnnMethod method() {
        return this.method;
    }

    @Nullable
    public final String mode() {
        return this.mode;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final Integer searchSize() {
        return this.searchSize;
    }

    @Nullable
    public final String spaceType() {
        return this.spaceType;
    }

    @Nonnull
    public final String trainingField() {
        return this.trainingField;
    }

    @Nonnull
    public final String trainingIndex() {
        return this.trainingIndex;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.compressionLevel != null) {
            generator.writeKey("compression_level");
            generator.write(this.compressionLevel);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("dimension");
        generator.write(this.dimension);
        if (this.maxTrainingVectorCount != null) {
            generator.writeKey("max_training_vector_count");
            generator.write(this.maxTrainingVectorCount.intValue());
        }
        if (this.method != null) {
            generator.writeKey("method");
            this.method.serialize(generator, mapper);
        }
        if (this.mode != null) {
            generator.writeKey("mode");
            generator.write(this.mode);
        }
        if (this.searchSize != null) {
            generator.writeKey("search_size");
            generator.write(this.searchSize.intValue());
        }
        if (this.spaceType != null) {
            generator.writeKey("spaceType");
            generator.write(this.spaceType);
        }
        generator.writeKey("training_field");
        generator.write(this.trainingField);
        generator.writeKey("training_index");
        generator.write(this.trainingIndex);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTrainModelRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::compressionLevel, JsonpDeserializer.stringDeserializer(), "compression_level");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::dimension, JsonpDeserializer.integerDeserializer(), "dimension");
        op.add(Builder::maxTrainingVectorCount, JsonpDeserializer.integerDeserializer(), "max_training_vector_count");
        op.add(Builder::method, KnnMethod._DESERIALIZER, "method");
        op.add(Builder::mode, JsonpDeserializer.stringDeserializer(), "mode");
        op.add(Builder::searchSize, JsonpDeserializer.integerDeserializer(), "search_size");
        op.add(Builder::spaceType, JsonpDeserializer.stringDeserializer(), "spaceType");
        op.add(Builder::trainingField, JsonpDeserializer.stringDeserializer(), "training_field");
        op.add(Builder::trainingIndex, JsonpDeserializer.stringDeserializer(), "training_index");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.preference != null) {
            params.put("preference", this.preference);
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.compressionLevel);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Integer.hashCode(this.dimension);
        result = 31 * result + Objects.hashCode(this.maxTrainingVectorCount);
        result = 31 * result + Objects.hashCode(this.method);
        result = 31 * result + Objects.hashCode(this.mode);
        result = 31 * result + Objects.hashCode(this.modelId);
        result = 31 * result + Objects.hashCode(this.preference);
        result = 31 * result + Objects.hashCode(this.searchSize);
        result = 31 * result + Objects.hashCode(this.spaceType);
        result = 31 * result + this.trainingField.hashCode();
        result = 31 * result + this.trainingIndex.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainModelRequest other = (TrainModelRequest)o;
        return Objects.equals(this.compressionLevel, other.compressionLevel) && Objects.equals(this.description, other.description) && this.dimension == other.dimension && Objects.equals(this.maxTrainingVectorCount, other.maxTrainingVectorCount) && Objects.equals(this.method, other.method) && Objects.equals(this.mode, other.mode) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.preference, other.preference) && Objects.equals(this.searchSize, other.searchSize) && Objects.equals(this.spaceType, other.spaceType) && this.trainingField.equals(other.trainingField) && this.trainingIndex.equals(other.trainingIndex);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TrainModelRequest> {
        @Nullable
        private String compressionLevel;
        @Nullable
        private String description;
        private Integer dimension;
        @Nullable
        private Integer maxTrainingVectorCount;
        @Nullable
        private KnnMethod method;
        @Nullable
        private String mode;
        @Nullable
        private String modelId;
        @Nullable
        private String preference;
        @Nullable
        private Integer searchSize;
        @Nullable
        private String spaceType;
        private String trainingField;
        private String trainingIndex;

        public Builder() {
        }

        private Builder(TrainModelRequest o) {
            super(o);
            this.compressionLevel = o.compressionLevel;
            this.description = o.description;
            this.dimension = o.dimension;
            this.maxTrainingVectorCount = o.maxTrainingVectorCount;
            this.method = o.method;
            this.mode = o.mode;
            this.modelId = o.modelId;
            this.preference = o.preference;
            this.searchSize = o.searchSize;
            this.spaceType = o.spaceType;
            this.trainingField = o.trainingField;
            this.trainingIndex = o.trainingIndex;
        }

        private Builder(Builder o) {
            super(o);
            this.compressionLevel = o.compressionLevel;
            this.description = o.description;
            this.dimension = o.dimension;
            this.maxTrainingVectorCount = o.maxTrainingVectorCount;
            this.method = o.method;
            this.mode = o.mode;
            this.modelId = o.modelId;
            this.preference = o.preference;
            this.searchSize = o.searchSize;
            this.spaceType = o.spaceType;
            this.trainingField = o.trainingField;
            this.trainingIndex = o.trainingIndex;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder compressionLevel(@Nullable String value) {
            this.compressionLevel = value;
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder dimension(int value) {
            this.dimension = value;
            return this;
        }

        @Nonnull
        public final Builder maxTrainingVectorCount(@Nullable Integer value) {
            this.maxTrainingVectorCount = value;
            return this;
        }

        @Nonnull
        public final Builder method(@Nullable KnnMethod value) {
            this.method = value;
            return this;
        }

        @Nonnull
        public final Builder method(Function<KnnMethod.Builder, ObjectBuilder<KnnMethod>> fn) {
            return this.method(fn.apply(new KnnMethod.Builder()).build());
        }

        @Nonnull
        public final Builder mode(@Nullable String value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        @Nonnull
        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        @Nonnull
        public final Builder searchSize(@Nullable Integer value) {
            this.searchSize = value;
            return this;
        }

        @Nonnull
        public final Builder spaceType(@Nullable String value) {
            this.spaceType = value;
            return this;
        }

        @Nonnull
        public final Builder trainingField(String value) {
            this.trainingField = value;
            return this;
        }

        @Nonnull
        public final Builder trainingIndex(String value) {
            this.trainingIndex = value;
            return this;
        }

        @Override
        @Nonnull
        public TrainModelRequest build() {
            this._checkSingleUse();
            return new TrainModelRequest(this);
        }
    }
}

