/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PythonPathEditor;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import com.jetbrains.python.ui.targetPathEditor.ManualPathEntryDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class PyRemotePathEditor
extends PythonPathEditor {
    private static final Logger LOG = Logger.getInstance(PyRemotePathEditor.class);
    private final RemoteSdkProperties myRemoteSdkData;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Sdk mySdk;
    private final List<PathMappingSettings.PathMapping> myNewMappings;

    PyRemotePathEditor(@NotNull Project project, @NotNull Sdk sdk2) {
        if (project == null) {
            PyRemotePathEditor.$$$reportNull$$$0(0);
        }
        if (sdk2 == null) {
            PyRemotePathEditor.$$$reportNull$$$0(1);
        }
        super(PyBundle.message("python.sdk.configuration.tab.title", new Object[0]), OrderRootType.CLASSES, FileChooserDescriptorFactory.createAllButJarContentsDescriptor());
        this.myNewMappings = new ArrayList<PathMappingSettings.PathMapping>();
        this.myProject = project;
        this.mySdk = sdk2;
        this.myRemoteSdkData = (RemoteSdkProperties)this.mySdk.getSdkAdditionalData();
    }

    @Override
    protected String getPresentablePath(VirtualFile value) {
        String path2 = value.getPath();
        return this.myRemoteSdkData.getPathMappings().convertToRemote(path2);
    }

    @Override
    protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
        toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                VirtualFile[] added = PyRemotePathEditor.this.doAddItems();
                if (added.length > 0) {
                    PyRemotePathEditor.this.setModified(true);
                }
                PyRemotePathEditor.this.requestDefaultFocus();
                PyRemotePathEditor.this.setSelectedRoots(added);
            }
        });
        super.addToolbarButtons(toolbarDecorator);
    }

    protected VirtualFile[] doAddItems() {
        try {
            String[] files = this.chooseRemoteFiles();
            String sourcesLocalPath = PySdkExtKt.getRemoteSourcesLocalPath(this.mySdk).toString();
            VirtualFile[] vFiles = new VirtualFile[files.length];
            int i = 0;
            for (String file : files) {
                String localRoot = PyRemoteSourceItem.localPathForRemoteRoot(sourcesLocalPath, file);
                this.myNewMappings.add(new PathMappingSettings.PathMapping(localRoot, file));
                this.myRemoteSdkData.getPathMappings().addMappingCheckUnique(localRoot, file);
                if (!new File(localRoot).exists()) {
                    new File(localRoot).mkdirs();
                }
                vFiles[i++] = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(localRoot));
            }
            vFiles = this.adjustAddedFileSet(this.myPanel, vFiles);
            ArrayList<VirtualFile> added = new ArrayList<VirtualFile>(vFiles.length);
            for (VirtualFile vFile : vFiles) {
                if (!this.addElement(vFile)) continue;
                added.add(vFile);
            }
            return VfsUtilCore.toVirtualFileArray(added);
        }
        catch (Exception e) {
            LOG.error("Failed to add Python paths", (Throwable)e);
            return VirtualFile.EMPTY_ARRAY;
        }
    }

    private String @NotNull [] chooseRemoteFiles() throws ExecutionException, InterruptedException {
        SdkAdditionalData sdkAdditionalData = this.mySdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase) {
            PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
            if (remoteInterpreterManager == null) {
                if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                    PyRemotePathEditor.$$$reportNull$$$0(2);
                }
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            String[] stringArray = remoteInterpreterManager.chooseRemoteFiles(this.myProject, (PyRemoteSdkAdditionalDataBase)sdkAdditionalData, false);
            if (stringArray == null) {
                PyRemotePathEditor.$$$reportNull$$$0(3);
            }
            return stringArray;
        }
        if (sdkAdditionalData instanceof PyTargetAwareAdditionalData) {
            ManualPathEntryDialog dialog = new ManualPathEntryDialog(this.myProject, ((PyTargetAwareAdditionalData)sdkAdditionalData).getTargetEnvironmentConfiguration());
            if (dialog.showAndGet()) {
                String[] stringArray = new String[]{dialog.getPath()};
                if (stringArray == null) {
                    PyRemotePathEditor.$$$reportNull$$$0(4);
                }
                return stringArray;
            }
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                PyRemotePathEditor.$$$reportNull$$$0(5);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            PyRemotePathEditor.$$$reportNull$$$0(6);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public void apply(SdkModificator sdkModificator) {
        if (sdkModificator.getSdkAdditionalData() instanceof RemoteSdkProperties) {
            for (PathMappingSettings.PathMapping mapping : this.myNewMappings) {
                ((RemoteSdkProperties)sdkModificator.getSdkAdditionalData()).getPathMappings().addMappingCheckUnique(mapping.getLocalRoot(), mapping.getRemoteRoot());
            }
        }
        super.apply(sdkModificator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/configuration/PyRemotePathEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/configuration/PyRemotePathEditor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseRemoteFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

