/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.history.ActivityId;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitActivity;
import git4idea.GitStashUsageCollector;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.i18n.GitBundle;
import git4idea.index.GitStageManagerKt;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.stash.GitStashOperations;
import git4idea.stash.ui.GitStashUIHandler;
import git4idea.ui.GitUnstashDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitStashChangesSaver
extends GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitStashChangesSaver.class);
    private static final String NO_LOCAL_CHANGES_TO_SAVE = "No local changes to save";
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final Map<VirtualFile, Hash> myStashedRoots;
    private boolean myReportLocalHistoryActivity;

    public GitStashChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull String stashMessage) {
        if (project == null) {
            GitStashChangesSaver.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitStashChangesSaver.$$$reportNull$$$0(1);
        }
        if (progressIndicator == null) {
            GitStashChangesSaver.$$$reportNull$$$0(2);
        }
        if (stashMessage == null) {
            GitStashChangesSaver.$$$reportNull$$$0(3);
        }
        super(project, git, progressIndicator, GitSaveChangesPolicy.STASH, stashMessage);
        this.myStashedRoots = new HashMap<VirtualFile, Hash>();
        this.myReportLocalHistoryActivity = true;
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
    }

    @Override
    protected void save(@NotNull Collection<? extends VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null) {
            GitStashChangesSaver.$$$reportNull$$$0(4);
        }
        LOG.info("saving " + String.valueOf(rootsToSave));
        ActivityId activityId = this.myReportLocalHistoryActivity ? GitActivity.Stash : null;
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message("activity.name.stash", new Object[0]), (ActivityId)activityId);){
            for (VirtualFile virtualFile : rootsToSave) {
                String message = GitBundle.message("stash.progress.indicator.title", virtualFile.getName());
                LOG.info(message);
                String oldProgressTitle = this.myProgressIndicator.getText();
                this.myProgressIndicator.setText(message);
                GitRepository repository2 = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(virtualFile);
                if (repository2 == null) {
                    LOG.error("Repository is null for root " + String.valueOf(virtualFile));
                } else {
                    StructuredIdeActivity activity = GitStashUsageCollector.logStashPush(this.myProject);
                    GitCommandResult result2 = this.myGit.stashSave(repository2, this.myStashMessage);
                    activity.finished();
                    if (result2.success() && GitStashChangesSaver.somethingWasStashed(result2)) {
                        this.myStashedRoots.put(virtualFile, this.myGit.resolveReference(repository2, "stash@{0}"));
                    } else {
                        if (!result2.success()) {
                            throw new VcsException(GitBundle.message("exception.message.could.not.stash.root.error", repository2.getRoot(), result2.getErrorOutputAsJoinedString()));
                        }
                        LOG.warn("There was nothing to stash in " + String.valueOf(repository2.getRoot()));
                    }
                }
                this.myProgressIndicator.setText(oldProgressTitle);
            }
        }
    }

    private static boolean somethingWasStashed(@NotNull GitCommandResult result2) {
        if (result2 == null) {
            GitStashChangesSaver.$$$reportNull$$$0(5);
        }
        return !StringUtil.containsIgnoreCase((String)result2.getErrorOutputAsJoinedString(), (String)NO_LOCAL_CHANGES_TO_SAVE) && !StringUtil.containsIgnoreCase((String)result2.getOutputAsJoinedString(), (String)NO_LOCAL_CHANGES_TO_SAVE);
    }

    @Override
    public void load() {
        String oldProgressTitle = this.myProgressIndicator.getText();
        GitStashOperations.unstash(this.myProject, this.myStashedRoots, (Function1<? super VirtualFile, ? extends GitLineHandler>)((Function1)root -> {
            String message = GitBundle.message("stash.unstash.progress.indicator.title", root.getName());
            this.myProgressIndicator.setText(message);
            GitLineHandler handler = new GitLineHandler(this.myProject, (VirtualFile)root, GitCommand.STASH);
            handler.addParameters("pop");
            if (GitStageManagerKt.isStagingAreaAvailable(this.myProject)) {
                handler.addParameters("--index");
            }
            return handler;
        }), new UnstashConflictResolver(this.myProject, this.myGit, this.myStashedRoots.keySet(), this.myParams), this.myReportLocalHistoryActivity);
        this.myProgressIndicator.setText(oldProgressTitle);
    }

    @Override
    public boolean wereChangesSaved() {
        return !this.myStashedRoots.isEmpty();
    }

    @Override
    public void showSavedChanges() {
        VirtualFile firstRoot = (VirtualFile)ContainerUtil.getFirstItem(this.myStashedRoots.keySet());
        GitStashUIHandler handler = (GitStashUIHandler)this.myProject.getService(GitStashUIHandler.class);
        if (handler.isStashTabAvailable()) {
            handler.showStashes(firstRoot);
        } else {
            GitUnstashDialog.showUnstashDialog(this.myProject, new ArrayList<VirtualFile>(this.myStashedRoots.keySet()), firstRoot);
        }
    }

    void setReportLocalHistoryActivity(boolean reportLocalHistoryActivity) {
        this.myReportLocalHistoryActivity = reportLocalHistoryActivity;
    }

    public String toString() {
        return "StashChangesSaver. Roots: " + String.valueOf(this.myStashedRoots);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stashMessage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "git4idea/stash/GitStashChangesSaver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "somethingWasStashed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UnstashConflictResolver
    extends GitConflictResolver {
        private final Set<? extends VirtualFile> myStashedRoots;

        UnstashConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull Set<? extends VirtualFile> stashedRoots, @Nullable GitConflictResolver.Params params) {
            if (project == null) {
                UnstashConflictResolver.$$$reportNull$$$0(0);
            }
            if (git == null) {
                UnstashConflictResolver.$$$reportNull$$$0(1);
            }
            if (stashedRoots == null) {
                UnstashConflictResolver.$$$reportNull$$$0(2);
            }
            super(project, stashedRoots, UnstashConflictResolver.makeParamsOrUse(params, project));
            this.myStashedRoots = stashedRoots;
        }

        private static GitConflictResolver.Params makeParamsOrUse(@Nullable GitConflictResolver.Params givenParams, Project project) {
            if (givenParams != null) {
                return givenParams;
            }
            GitConflictResolver.Params params = new GitConflictResolver.Params(project);
            params.setErrorNotificationTitle(GitBundle.message("preserving.process.local.changes.not.restored.error.title", new Object[0]));
            params.setMergeDialogCustomizer(new UnstashMergeDialogCustomizer());
            params.setReverse(true);
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
            VcsNotifier.importantNotification().createNotification(GitBundle.message("stash.unstash.unresolved.conflict.warning.notification.title", new Object[0]), GitBundle.message("stash.unstash.unresolved.conflict.warning.notification.message", new Object[0]), NotificationType.WARNING).setDisplayId("git.unstash.with.conflicts").addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("stash.unstash.unresolved.conflict.warning.notification.show.stash.action", new Object[0]), () -> {
                VirtualFile firstRoot = (VirtualFile)ContainerUtil.getFirstItem(this.myStashedRoots);
                GitStashUIHandler handler = (GitStashUIHandler)this.myProject.getService(GitStashUIHandler.class);
                if (handler.isStashTabAvailable()) {
                    handler.showStashes(firstRoot);
                } else {
                    GitUnstashDialog.showUnstashDialog(this.myProject, new ArrayList<VirtualFile>(this.myStashedRoots), firstRoot);
                }
            })).addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("stash.unstash.unresolved.conflict.warning.notification.resolve.conflicts.action", new Object[0]), () -> this.mergeNoProceedInBackground())).notify(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "git";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stashedRoots";
                    break;
                }
            }
            objectArray[1] = "git4idea/stash/GitStashChangesSaver$UnstashConflictResolver";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnstashMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private UnstashMergeDialogCustomizer() {
        }

        @NotNull
        public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
            if (files == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(0);
            }
            String string = GitBundle.message("stash.unstash.conflict.dialog.description.label.text", new Object[0]);
            if (string == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getLeftPanelTitle(@NotNull VirtualFile file) {
            if (file == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(2);
            }
            String string = GitChangesSaver.getConflictLeftPanelTitle();
            if (string == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getRightPanelTitle(@NotNull VirtualFile file, VcsRevisionNumber revisionNumber) {
            if (file == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(4);
            }
            String string = GitChangesSaver.getConflictRightPanelTitle();
            if (string == null) {
                UnstashMergeDialogCustomizer.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/stash/GitStashChangesSaver$UnstashMergeDialogCustomizer";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/stash/GitStashChangesSaver$UnstashMergeDialogCustomizer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMultipleFileMergeDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeftPanelTitle";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRightPanelTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMultipleFileMergeDescription";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLeftPanelTitle";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getRightPanelTitle";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 5 -> new IllegalStateException(string);
            };
        }
    }
}

