/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant.jmx;

import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.catalina.ant.jmx.JMXAccessorTask;
import org.apache.tools.ant.BuildException;

public class JMXAccessorSetTask
extends JMXAccessorTask {
    private String attribute;
    private String value;
    private String type;
    private boolean convert = false;

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String string) {
        this.attribute = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isConvert() {
        return this.convert;
    }

    public void setConvert(boolean bl) {
        this.convert = bl;
    }

    @Override
    public String jmxExecute(MBeanServerConnection mBeanServerConnection) throws Exception {
        if (this.getName() == null) {
            throw new BuildException("Must specify a 'name'");
        }
        if (this.attribute == null || this.value == null) {
            throw new BuildException("Must specify a 'attribute' and 'value' for set");
        }
        return this.jmxSet(mBeanServerConnection, this.getName());
    }

    protected String jmxSet(MBeanServerConnection mBeanServerConnection, String string) throws Exception {
        Object object;
        if (this.type != null) {
            object = this.convertStringToType(this.value, this.type);
        } else if (this.isConvert()) {
            String string2 = this.getMBeanAttributeType(mBeanServerConnection, string, this.attribute);
            object = this.convertStringToType(this.value, string2);
        } else {
            object = this.value;
        }
        mBeanServerConnection.setAttribute(new ObjectName(string), new Attribute(this.attribute, object));
        return null;
    }

    protected String getMBeanAttributeType(MBeanServerConnection mBeanServerConnection, String string, String string2) throws Exception {
        ObjectName objectName = new ObjectName(string);
        String string3 = null;
        MBeanInfo mBeanInfo = mBeanServerConnection.getMBeanInfo(objectName);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        for (int i = 0; string3 == null && i < mBeanAttributeInfoArray.length; ++i) {
            if (!string2.equals(mBeanAttributeInfoArray[i].getName())) continue;
            string3 = mBeanAttributeInfoArray[i].getType();
        }
        return string3;
    }
}

